#dinges
import sys
import math
from demoscript import PSLayer, getTime, getEvent, EC_NOTE_ON


class Logo(PSLayer):

  def __init__(self, name):
    PSLayer.__init__(self, name)
    self.scale = 1.0
    self.x = 0
    self.y = 0
    self.ts = -1

  def callback(self):
    t = getTime()
    if getEvent(EC_NOTE_ON,"bass"):
      self.ts = t

    c = (t - self.ts)*5
    if c < 0:
      c = 0
    if c > 1:
      c = 1
    self.r = c+0.5
    self.g = c+0.5
    self.b = c+0.5
    self.y = 0.4 - c*0.01


class Number(PSLayer):
  def __init__(self, name, id):
    PSLayer.__init__(self, name)
    self.scale = 1.0
    self.x = 0
    self.y = 0
    self.ts = -1
    self.id = id

  def callback(self):
    t = getTime()
    if getEvent(EC_NOTE_ON,`self.id`):
      self.ts = t

    c = 1.0 - (t - self.ts)*5
    if c < 0:
      c = 0

    if c > 1:
      c = 1

    self.r = -c + 1
    self.g = -c + 1
    self.b = -c + 1
  
    self.y = 0.4 - c*0.04
